import refreshTokenHelper from "../../../../utils/refreshTokenHelper"
import getTokenHelper from "../../../../utils/getTokenHelper"
import forceLogoutHelper from "../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../utils/fetchHelper"
import laravelHelper from "../../../../utils/laravelHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.uomId) {
    newObjValue = {...newObjValue, 
      C_UOM_ID: {
        id: body.uomId,
        tableName: 'C_UOM'
      }
    }
  }
  if(body.locatorId) {
    newObjValue = {...newObjValue, 
      M_Locator_ID: {
        id: body.locatorId,
        tableName: 'M_Locator'
      }
    }
  }
  if(body.orderLineId) {
    newObjValue = {...newObjValue, 
      C_OrderLine_ID: {
        id: body.orderLineId,
        tableName: 'C_OrderLine'
      }
    }
  }
  if(body.attributeSetInstanceId) {
    newObjValue = {...newObjValue, 
      M_AttributeSetInstance_ID: {
        id: body.attributeSetInstanceId,
        tableName: 'M_AttributeSetInstance'
      }
    }
  }
  if(body.projectId) {
    newObjValue = {...newObjValue, 
      C_Project_ID: {
        id: body.projectId,
        tableName: 'C_Project'
      }
    }
  }
  if(body.campaignId) {
    newObjValue = {...newObjValue, 
      C_Campaign_ID: {
        id: body.campaignId,
        tableName: 'C_Campaign'
      }
    }
  }

  if(body.id) {
    const res: any = await fetchHelper(event, 'models/m_inoutline/'+body.id, 'PUT', token, {
      isActive: body.isActive,
      //line: body.line,
      //isAutoProduce: body.isAutoProduce,
      qtyEntered: body.qtyEntered,
      //processed: body.processed,
      //targetQty: body.targetQty,
      //scrappedQty: body.scrappedQty,
      //pickedQty: body.pickedQty,
      //confirmedQty: body.confirmedQty,
      //isDescription: body.isDescription,
      //isInvoiced: body.isInvoiced,
      description: body.description,
      movementQty: body.movementQty,
      ...newObjValue,
      tableName: 'm_inoutline'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''

      // After updating material receipt line, check if we need to send JTL incoming goods bulk
      try {
        // Get the line ID from route params to fetch the parent receipt
        const id = getRouterParam(event, 'id')

        // Fetch material receipt with order details
        const receipt: any = await fetchHelper(event, 'models/m_inout/'+id+'?$expand=c_order_id,c_bpartner_location_id', 'GET', token, null)

        // Check conditions: purchase receipt with order that has order source and jtl_order_id
        if(receipt?.IsSOTrx === false && receipt?.C_Order_ID?.C_OrderSource_ID?.id && receipt?.C_Order_ID?.jtl_order_id) {
          // Fetch order source details
          const orderSource: any = await fetchHelper(event, 'models/c_ordersource/'+receipt.C_Order_ID.C_OrderSource_ID.id, 'GET', token, null)

          // Verify it's JTL-FFN and has marketplace_url
          if((orderSource?.Marketplace?.identifier === 'jtl-ffn' || orderSource?.marketplace === '7' || orderSource?.Marketplace?.id === '7') && orderSource?.marketplace_url) {
            const jtlOrderId = receipt.C_Order_ID.jtl_order_id

            const logData = {
              jtl_order_id: jtlOrderId,
              material_receipt_id: id,
              material_receipt_line_id: body.id,
              order_id: receipt.C_Order_ID.id,
              updated_qty: body.movementQty,
              marketplace_url: orderSource.marketplace_url
            }
            console.log('[JTL Incoming Goods] Material receipt line updated for JTL order:', logData)
            data['jtl_incoming_goods_log'] = { trigger: logData }

            try {
              const requestLog = {
                endpoint: 'sales/orders/post-jtl-incoming-goods-bulk',
                jtl_order_id: jtlOrderId
              }
              console.log('[JTL Incoming Goods] Sending bulk confirmation to JTL...', requestLog)
              data['jtl_incoming_goods_log'] = { ...data['jtl_incoming_goods_log'], request: requestLog }

              const resp4: any = await laravelHelper(event, 'sales/orders/post-jtl-incoming-goods-bulk', 'POST', {
                orderSource: orderSource,
                id: jtlOrderId
              })

              const responseLog = {
                success: true,
                response: resp4
              }
              console.log('[JTL Incoming Goods] Bulk confirmation response:', responseLog)
              data['jtl_incoming_goods_log'] = { ...data['jtl_incoming_goods_log'], response: responseLog }

            } catch(err: any) {
              const errorLog = {
                error: err?.data ?? err,
                jtl_order_id: jtlOrderId
              }
              console.error('[JTL Incoming Goods] Error sending bulk confirmation:', errorLog)
              data['jtl_incoming_goods_log'] = { ...data['jtl_incoming_goods_log'], error: errorLog }
              // Don't fail the line update if JTL request fails
            }
          }
        }
      } catch(err: any) {
        console.error('[JTL Incoming Goods] Error in incoming goods flow:', err)
        // Don't fail the line update if JTL integration fails
      }
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})